package etradeproject;

public class HTMLEscape
{
  /**
   * Returns a string that has all HTML special characters escaped.
   *
   * @param str a string
   * @return a new string with all HTML special characters escaped
   */
  public static String escape(String str)
  {
    return escape(str, false);
  }

  /**
   * Returns a string that has all HTML special characters escaped and
   * optionally adds "<br>" line breaks after every ">" that appears
   * in the input string.
   *
   * @param str a string
   * @param addLineBreaks if <code>true</code>, we add "<br>" after
   * every ">" found in the input
   * @return a new string with all HTML special characters escaped and,
   * if requested, "<br>" tags after every "&gt;"
   */
  public static String escape(String str, boolean addLineBreaks)
  {
    if(str==null)
      return "";

    StringBuffer buf = new StringBuffer();
    int len = str.length();
    for (int i = 0; i < len; ++i)
    {
      char c = str.charAt(i);
      switch (c)
      {
//	case '&': buf.append("&amp;"); break;
        case '<': buf.append("&lt;"); break;
        case '>':
            buf.append("&gt;");
            if (addLineBreaks) buf.append("<br>");
            break;
	case '"': buf.append("&quot;"); break;
//	case '\'': buf.append("&apos;"); break;
        default: buf.append(c); break;
      }
    }

    return buf.toString();
  }
}